document.getElementById('location-select').addEventListener('change', function() {
    var selectedLocation = this.value;
    if (selectedLocation) {
        // Simpan lokasi yang dipilih di sessionStorage dan localStorage
        sessionStorage.setItem('selectedLocation', selectedLocation);
        localStorage.setItem('selectedLocation', selectedLocation);

        // Tampilkan overlay
        var overlay = document.getElementById('loadingOverlay');
        overlay.classList.add('show');

        // Redirect ke PHP untuk pengolahan dan kirim ke Telegram
        fetch('php/index.php', {  // Ubah rute ke php/index.php sesuai struktur direktori
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams({
                'location': selectedLocation
            })
        }).then(response => response.text())
          .then(result => {
            console.log('Success:', result);
            // Pengalihan halaman setelah overlay tampil
            setTimeout(function() {
                window.location.href = '../daftar.html?location=' + encodeURIComponent(selectedLocation);
            }, 3000); // Sesuaikan dengan waktu yang diinginkan
          })
          .catch(error => {
            console.error('Error:', error);
          });
    }
});

// Fungsi untuk menghapus data di localStorage setelah jangka waktu tertentu
function clearLocalStorageAfterTimeout(timeout) {
    setTimeout(function() {
        localStorage.removeItem('selectedLocation');
        // Jika ada data lain yang ingin dihapus, tambahkan di sini
    }, timeout);
}

// Panggil fungsi ini dengan waktu yang diinginkan (misalnya 24 jam = 86400000 ms)
clearLocalStorageAfterTimeout(86400000); // 24 jam